<?php defined('SYSPATH') or die('No direct script access.');

class Model_Client extends ORM {
	protected $_table_name = 'clients';
	protected $_primary_key = 'id';
	protected $_table_columns = [
		'id' => NULL,
		'cid1' => NULL,
		'cid0' => NULL,
		'prefix' => NULL,
		'version' => NULL,
		'net' => NULL,
		'system' => NULL,
		'ip' => NULL,
		'location' => NULL,
		'registered' => NULL,
		'lastactivity' => NULL,
		'silent' => NULL,
	];

	protected $_has_many = [
		'logpost'       => [
			'model' => 'Logpost',
			'foreign_key' => 'client_id'
		]
	];

	/**
	 * @param  mixed $client client_name: DAB756F2594BDA0C49ED7AAC3C1140DC
	 * @return mixed
	 */
	public static function getCid($client){
		$cid1 = DB::expr("x'".substr($client, 0, 16)."'::BIGINT AS cid1");
		$cid0 = DB::expr("x'".substr($client, -16)."'::BIGINT AS cid0");
		$tmp = DB::select($cid1, $cid0)
			->execute()
			->as_array();
		return $tmp[0];
	}

	/**
	 * @param  mixed $param array: [cid1, cid0] || client_name: DAB756F2594BDA0C49ED7AAC3C1140DC || int: id
	 * @return mixed
	 */
	public static function getClientInfo($param){
		$clientName = DB::expr("upper(lpad(to_hex(cid1), 16, '0') || lpad(to_hex(cid0), 16, '0')) AS client");
		$query = DB::select('*', $clientName)->from('clients');

		if(is_array($param)){
			$query = $query->where('cid1', '=', $param['cid1'])->and_where('cid0', '=', $param['cid0']);
		}elseif(is_string($param) && preg_match('#^[0-9A-F]{32}$#', $param)){
			$cids = Model_Client::getCid($param);
			$query = $query->where('cid1', '=', $cids['cid1'])->and_where('cid0', '=', $cids['cid0']);
		}elseif(is_int(intval($param)) && intval($param) != 0){
			$query = $query->where('id', '=', $param);
		}else{
			return false;
		}

		$result = $query->limit(1)
			->execute()
			->as_array();

		if(!empty($result))
			return $result[0];
		else
			return false;
	}

    public function getClientID(){
        $base_length = 16;
        $name = null;
        if($this->cid1 != 0){
            $lenght = strlen(dechex($this->cid1));
            if($lenght != $base_length){
                $delta = $base_length - $lenght;
                for($i = 0; $i < $delta; $i++){
                    $name .= '0';
                }
            }
            $name .= dechex($this->cid1);
        }
        if($this->cid0 != 0){
            $lenght = strlen(dechex($this->cid0));
            if($lenght != $base_length){
                $delta = $base_length - $lenght;
                for($i = 0; $i < $delta; $i++){
                    $name .= '0';
                }
            }
            $name .= dechex($this->cid0);
        }
        return mb_strtoupper($name);
    }

    public function getFullName(){
        if($this->loaded())
            return trim($this->prefix).'.'.$this->getClientID();
        return false;
    }
}

